from __future__ import unicode_literals

import atexit
import logging
import sys

from instancectl import constants
from instancectl.clients.unixsocket_rpc import client
from instancectl.clients.unixsocket_rpc import exceptions
from infra.nanny.instancectl.proto import instancectl_pb2
from infra.nanny.instancectl.proto import instancectl_stub
from instancectl.utils import get_event_logger
from instancectl.cmd import log as setup_logging


log = logging.getLogger('actions.stop')
event_log = get_event_logger('stop')


def stop_instance(args, console_handler):
    setup_logging.setup_logging(console_handler, args.console)
    log.info("Stopping all")

    @atexit.register
    def log_exit():
        log.info("Exited")

    url = '{}{}/rpc/control'.format(client.UNIX_SOCKET_SCHEME, constants.UNIXSOCKET_PATH)
    rpc = client.UnixsocketRpcClient(rpc_url=url)
    stub = instancectl_stub.InstanceRevisionServiceStub(rpc)
    req = instancectl_pb2.StopInstanceRequest()
    try:
        resp = stub.stop_instance(req)
        if not resp.success:
            sys.exit(1)
    except exceptions.ConnectionError:
        # FYI
        # It could be a race when request comes right before opening socket:
        # stop action returns zero exit code, instance will work on.
        # This is in the nature of things, we can do nothing with it
        pass


def add_parsers(subparsers):
    parser = subparsers.add_parser(name='stop', description='Request instance stop')
    parser.set_defaults(handle=stop_instance)
    parser.add_argument(
        "-c", "--config", metavar="CONFIGFILE", dest="config",
        help="config file", type=str, default='loop.conf',
    )
