from __future__ import unicode_literals

import atexit
import logging

from instancectl.lib import actionsutil
from instancectl.cmd import log as setup_logging

log = logging.getLogger('actions.uninstall')


def uninstall_action(args, console_handler):
    """
    Makes actions before the instance removal from host.
    """
    setup_logging.setup_logging(console_handler, args.console)
    log.info("Uninstalling instance")

    @atexit.register
    def log_exit():
        log.info("Exited")

    action = actionsutil.make_uninstall_action(args.config, args.hq_url)
    try:
        action.run()
    finally:
        action.stop()


def add_parsers(subparsers):
    parser = subparsers.add_parser(
        name='uninstall',
        description='Specific instance uninstalling actions: (report instance uninstalled to HQ)'
    )
    parser.set_defaults(handle=uninstall_action)
    parser.add_argument(
        "-c", "--config", metavar="CONFIGFILE", dest="config",
        help="config file", type=str, default='loop.conf',
    )
    parser.add_argument(
        "--hq-url", metavar="HQ_URL", dest="hq_url",
        help="HQ URL", type=str, default=None,
    )

