# coding=utf-8
import errno
import os

import iss3lib.info

import gevent

STATE_DIR = 'state'
COMPILED_CONFIG_LOCK_PATH = 'state/config_compile.lock'
COMPILED_CONFIG_PATH = 'state/instance.conf'


class CmsType(object):
    BSCONFIG = 'bsconfig'
    ISS = 'iss'

    def __init__(self, cms):
        """
        :type cms: str
        """
        self.cms = cms

    def is_iss(self):
        return self.cms == self.ISS

    def is_bsconfig(self):
        return self.cms == self.BSCONFIG


def detect_cms_agent_type():
    """
    Определяем под каким CMS мы запущены

    пока смотрим по файлу dump.json, позже в iss обещали сделать отдельную переменную окружения

    :return CmsTypes: объект типа CMS
    """
    # FIXME: ISS не гарантирует наличие dump.json в директории инстанса, возможно нужно ориентироваться на env var ISS?
    if os.path.exists('dump.json'):
        return CmsType(CmsType.ISS)
    else:
        return CmsType(CmsType.BSCONFIG)


def load_dump_json(dump_dir='.', read_attempts=3, delay=0.01):
    """
    Получить содержимое dump.json

    :type dump_dir: str | unicode
    :param dump_dir: путь до папки с дампом
    :type read_attempts: int
    :param read_attempts: число попыток чтения dump.json
    :type delay: int | float
    :param delay: перерыв между попытками чтения dump.json

    :rtype: dict
    """
    # XXX: ISS не всегда гарантирует наличие dump.json в директории инстанса: ISS-2812, SWAT-2474
    # мы в свою очередь обкостыливаем случай его отсутствия тремя попытками чтения
    attempt = 0
    while True:
        try:
            return iss3lib.info.load_instance_state(dump_dir)
        except IOError as e:
            if e.errno != errno.ENOENT:
                raise
            if attempt >= read_attempts - 1:
                raise
        gevent.sleep(delay)
        attempt += 1
