import resource

from instancectl import constants


mandatory_defaults = {
    'pid_file': '%(pids_dir)s/%(section)s',
    'lock_file': '%(state_dir)s/%(section)s.lock',  # FIXME: make same as pid_file
    'stderr': '%(section)s.err',
    'stdout': '%(section)s.out',
    'logs_dir': '/usr/local/www/logs',
    'state_dir': 'state',
    'pids_dir': 'pids',
}

run_limit_types = {
    'core': resource.RLIMIT_CORE,
    'as': resource.RLIMIT_AS,
    'nofile': resource.RLIMIT_NOFILE,
    'nproc': resource.RLIMIT_NPROC,
    'rss': resource.RLIMIT_RSS
}

default_run_limits = {}
for limit in run_limit_types.keys():
    default_run_limits['limit_' + limit] = ''

optional_defaults = {
    'rename_binary': '',
    'prepare_script': '',
    'install_script': '',
    'uninstall_script': '',
    'restart_script': '',
    'stop_script': '',
    'reopenlog_script': '',
    'status_script': '',
    'notify_script': '',
    'Conf.local': 'Conf.local',
    'env_match': '',
    'opt_match': '',
    'conf_match': '',
    'coredump_probability': '2',
    'always_coredump': 'False',
    'core_pattern': '',
    'use_porto': 'False',
    'delay': str(constants.DEFAULT_CONTAINER_RESTART_MIN_DELAY),
    'backoff': str(constants.DEFAULT_CONTAINER_RESTART_BACKOFF),
    'max_delay': str(constants.DEFAULT_CONTAINER_RESTART_MAX_DELAY),
    'max_jitter': str(constants.DEFAULT_CONTAINER_RESTART_MAX_JITTER),
    'successful_start_timeout': str(constants.DEFAULT_CONTAINER_RESTART_SUCCESSFUL_START_TIMEOUT),
    'status_check_type': '',
    'status_check_list': '',
    'status_check_required_lifetime': str(constants.STATUS_UPDATE_INITIAL_DELAY_SECONDS),
    'status_check_timeout': '3600',  # 1 hour
    'kill_timeout': str(constants.DEFAULT_CONTAINER_KILL_TIMEOUT),
    'terminate_timeout': str(constants.DEFAULT_CONTAINER_TERMINATE_TIMEOUT),
    'minidumps_push': '',
    'minidumps_library': './breakpad_init.so',
    'minidumps_stackwalk': './minidump_stackwalk',
    'minidumps_symbols': '',
    'minidumps_aggregator': 'saas_aggregator',
    'minidumps_aggregator_url': 'http://cores.n.yandex-team.ru/corecomes',
    'minidumps_path': '',
    'minidumps_service': '',
    'minidumps_product_version': '',
    'minidumps_build_id': '',
    'minidumps_timeout_before_sending': '300',
    'minidumps_check_timeout': '300',
    'minidumps_clean_timeout': '300',
    'hq_log_tail_byte_limit': '512',
    'coredumps_dir': constants.DEFAULT_COREDUMPS_DIR,
    'coredumps_gdb_path': './gdb/bin/gdb',
    'coredumps_format': 'minidump',
    'coredumps_send_overall_timeout': '300',
    'coredumps_gdb_stackwalk_timeout': '1200',
    'coredumps_filemask': '',
    'coredumps_count_limit': '10',
}

global_options = {
    'its_poll': '',
    'its_url': constants.DEFAULT_ITS_URL,
    'crash_log_dir': 'crash',
    'its_max_poll_timeout': str(constants.ITS_RETRY_MAX_PERIOD),
    'its_force_poll_timeout': str(constants.ITS_PERIOD),
    'its_poll_timeout': str(constants.ITS_PERIOD),
    'its_max_timeout_jitter': str(constants.ITS_PERIOD_JITTER),
    'its_connection_timeout': str(constants.ITS_REQUEST_TIMEOUT),
    'its_shared_storage': '',
    'its_symlink_controls': '',
    'action_stop_timeout': str(constants.DEFAULT_INSTANCE_STOP_TIMEOUT),
    'status_check_tries': '3',
    'status_check_min_delay': '5.0',
    'status_check_backoff': '1.0',
    'status_check_max_delay': '5.0',
    'status_check_req_timeout': '30.0',
    'status_update_max_restart_period': str(constants.STATUS_UPDATE_MAX_RESTART_PERIOD),
    'status_update_min_restart_period': str(constants.STATUS_UPDATE_MIN_RESTART_PERIOD),
    'status_update_restart_period_backoff': str(constants.DEFAULT_STATUS_UPDATE_BACKOFF),
    'hq_report': '',
    'hq_url': '',
    'hq_default_url_msk': 'http://hq.msk-swat.yandex-team.ru/',
    'hq_default_url_sas': 'http://hq.sas-swat.yandex-team.ru/',
    'hq_default_url_man': 'http://hq.man-swat.yandex-team.ru/',
    'hq_default_url_vla': 'http://hq.vla-swat.yandex-team.ru/',
    'hq_default_url': 'http://hq.msk-swat.yandex-team.ru/',
    'hq_min_report_delay': '5.0',
    'hq_max_report_delay': '180.0',
    'hq_max_report_delay_jitter': '30.0',
    'hq_report_timeout': '5.0',
    'hq_poll': '',
    'vault_url': constants.DEFAULT_VAULT_URL,
    'yav_url': constants.DEFAULT_YAV_URL,
    'tvm_api_url': constants.DEFAULT_TVM_API_URL,
    'tvm_client_id': str(constants.DEFAULT_TVM_CLIENT_ID),
    'yav_tvm_client_id': str(constants.DEFAULT_YAV_TVM_CLIENT_ID),
    'use_true_liveness': '',
    'liveness_criterion_type': 'all',
    'liveness_criterion_list': '',
    'federated_url': constants.DEFAULT_FEDERATED_URL,
}

total_defaults = {}
total_defaults.update(mandatory_defaults)
total_defaults.update(default_run_limits)
total_defaults.update(optional_defaults)
# total_defaults.update(global_options)
mandatory_parameters = ('arguments', 'binary', 'section')
