from __future__ import unicode_literals


# IMPORTANT: This list is used in shared its state volume name generation. Change with care.
ORTHOGONAL_TAG_LIST = ["a_ctype", "a_geo", "a_itype", "a_prj", "a_dc", "a_tier"]


# IMPORTANT: Order of the elements in the list is significant for the state volume name generation. Change with care.
ITS_STATE_VOLUME_NAME_TAG_LIST = ["a_ctype", "a_geo", "a_itype", "a_prj"]
ITS_REFRESH_FLAG_FILENAME = './refresh.flag'
ITS_SHARED_STORAGE_TEMPLATE = '{cms_path}/webstate/its_shared_controls/{host}:{port}-{tags}'

ITS_ISS_SHARED_STORAGE_PATH = '/db/iss3'
ITS_BSCONFIG_SHARED_STORAGE_PATH = '/db/bsconfig'

ITS_FIRST_POLL_TIMEOUT = 5  # seconds
ITS_PERIOD = 60  # seconds
ITS_PERIOD_JITTER = 5  # seconds
ITS_RETRY_MIN_PERIOD = 60  # seconds
ITS_RETRY_MAX_PERIOD = 300  # seconds
ITS_REQUEST_TIMEOUT = 5  # seconds
ITS_CONTROLS_DIR = 'controls'

DEFAULT_COREDUMPS_DIR = '/coredumps'

# State files, locks, logs and flag-files
# The lock is used for checking instancectl aliveness.
STATE_DIR = 'state'
LOOP_LOCK_RELATIVE_PATH = './state/loop.lock'
ACCESS_LOG_FILENAME = 'instancectl_access.log'
UNIXSOCKET_PATH = 'instancectl.sock'
CRASH_LOG_PATH = 'crash/crash.log'
RUN_FLAG_PATH = 'run.flag'
PIDS_DIR = './pids'

PORTOPOWERED_ITAG = 'portopowered'

# These values are used in instance state reports to HQ
CONDITION_FALSE = 'False'
CONDITION_TRUE = 'True'
CONDITION_UNKNOWN = 'Unknown'

STATUS_CHECK_TRIES = 3
STATUS_CHECK_BACKOFF = 1.0
STATUS_CHECK_MIN_DELAY = 5.0
STATUS_CHECK_MAX_DELAY = 5.0
STATUS_CHECK_REQ_TIMEOUT = 30.0
CHECK_PORT_TIMEOUT = 5

PORTO_CONTAINER_ENV_VAR = 'PORTO_NAME'

LOG_MAX_BYTES = 10 ** 7
LOG_BACKUP_COUNT = 10

WEB_SERVER_STOP_TIMEOUT = 1  # timeout that we wait for the client connections to close in stop()
WEB_SERVER_POOL_SIZE = 5


RUN_CONTAINERS_FROM_HQ_SPEC = 'use_hq_spec'
ENABLE_HQ_REPORT = 'enable_hq_report'
ENABLE_HQ_POLL = 'enable_hq_poll'
NANNY_SERVICE_ID_OPTION = 'NANNY_SERVICE_ID'


STATUS_UPDATE_MIN_RESTART_PERIOD = 5
STATUS_UPDATE_MAX_RESTART_PERIOD = 60
STATUS_UPDATE_RESTART_PERIOD_BACKOFF = 2
STATUS_UPDATE_INITIAL_DELAY_SECONDS = 5


HQ_MIN_REPORT_DELAY = 5.0
HQ_MAX_REPORT_DELAY = 180.0
HQ_MAX_REPORT_DELAY_JITTER = 30.0
HQ_LOG_TAIL_BYTE_LIMIT = 512


DEFAULT_VAULT_URL = 'https://nanny-vault.yandex-team.ru'
DEFAULT_TVM_API_URL = 'https://tvm-api.yandex.net'
DEFAULT_FEDERATED_URL = 'http://federated.yandex-team.ru'
DEFAULT_ITS_URL = 'http://its.yandex-team.ru/v1'
DEFAULT_TVM_CLIENT_ID = 2002924

# prod:
DEFAULT_YAV_TVM_CLIENT_ID = 2001357
DEFAULT_YAV_URL = 'https://vault-api.passport.yandex.net'
# testing:
# DEFAULT_YAV_TVM_CLIENT_ID = 2000733
# DEFAULT_YAV_URL = 'https://vault-api-test.passport.yandex.net'

# Params related to containers restart/stop delays
DEFAULT_CONTAINER_RESTART_MIN_DELAY = 1
DEFAULT_CONTAINER_RESTART_BACKOFF = 2
DEFAULT_CONTAINER_RESTART_MAX_DELAY = 60
DEFAULT_CONTAINER_RESTART_MAX_JITTER = 20
DEFAULT_CONTAINER_RESTART_SUCCESSFUL_START_TIMEOUT = 60
DEFAULT_CONTAINER_TERMINATE_TIMEOUT = 0
DEFAULT_CONTAINER_KILL_TIMEOUT = 10

DEFAULT_STATUS_UPDATE_BACKOFF = 1.1  # https://st.yandex-team.ru/SWAT-5926

# Default instance stop timeouts
DEFAULT_INSTANCE_STOP_TIMEOUT = 60
DEFAULT_INSTANCE_SPEC_STOP_TIMEOUT = 18000

DEFAULT_HTTP_GET_RUNNER_TIMEOUT = 180

INSTANCECTL_MEM_LIMIT_RESERVED = 100 * 1024 * 1024  # 100 MB
INSTANCECTL_MEM_GUARANTEE_RESERVED = 100 * 1024 * 1024  # 100 MB
INSTANCECTL_CPU_LIMIT_RESERVED = 500  # Milliseconds
INSTANCECTL_CPU_GUARANTEE_RESERVED = 500  # Milliseconds

SYMLINKING_RESOURCES_BLACKLIST = [
    'instancectl',
    'loop-httpsearch',
    'loop.conf',
    'instancectl.conf',
    'sshd',
    'iss_hook_start',
    'iss_hook_stop',
    'iss_hook_install',
    'iss_hook_uninstall',
    'iss_hook_reopenlog',
    'iss_hook_reopenlogs',
    'iss_hook_status',
    'iss_hook_validate',
    'iss_hook_notify',

]

# Format status for "get status"
STATUS_FORMAT_JSON = "json"
STATUS_FORMAT_HUMAN = "human"

AUX_DAEMONS_NAMES = (
    'skynet',
    'logrotate',
    'juggler',
)

CAP_NET_BIND_SERVICE = 'NET_BIND_SERVICE'

STDOUT_STDERR_SIZE_LIMIT_BYTES = 1 * 1024 * 1024  # 1 Megabyte

# FALLOC_FL_COLLAPSE_RANGE is not defined in fallocate module
FALLOC_FL_COLLAPSE_RANGE = 0x08

YP_LITE_DEFAULT_INSTANCE_PORT = 80

NODE_AGENT_YP_SOCKET_PATH = '%2Frun%2Fiss%2Fpod.socket'

DEFAULT_PREPARE_SCRIPT_MAX_TRIES = -1
DEFAULT_PREPARE_SCRIPT_MIN_DELAY = 1
DEFAULT_PREPARE_SCRIPT_BACKOFF = 2
DEFAULT_PREPARE_SCRIPT_MAX_DELAY = 180
DEFAULT_PREPARE_SCRIPT_MAX_JITTER = 3

DEFAULT_INSTALL_SCRIPT_MAX_TRIES = -1
DEFAULT_INSTALL_SCRIPT_MIN_DELAY = 1
DEFAULT_INSTALL_SCRIPT_BACKOFF = 1.05
DEFAULT_INSTALL_SCRIPT_MAX_DELAY = 7 * 24 * 60 * 60
DEFAULT_INSTALL_SCRIPT_MAX_JITTER = 3
