# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import requests
import nanny_rpc_client
from nanny_rpc_client import exceptions
from sepelib.util.retry import Retry, RetrySleeper

from yp_proto.yp.client.hq.proto import federated_pb2
from infra.nanny2.stubs.python import federated_stub

class FederatedClient(object):
    _DEFAULT_REQ_TIMEOUT = 5.0

    def __init__(self, url, req_timeout=None):
        self.url = url
        self.req_timeout = req_timeout or self._DEFAULT_REQ_TIMEOUT
        federated_url = '{}/rpc/federated/'.format(self.url.rstrip('/'))
        federated_rpc = nanny_rpc_client.RequestsRpcClient(rpc_url=federated_url, request_timeout=self.req_timeout)
        self._federated_stub = federated_stub.FederatedClusterServiceStub(federated_rpc)
        self._retry = Retry(retry_sleeper=RetrySleeper(max_tries=3, delay=1, backoff=3),
                            retry_exceptions=(exceptions.RpcError, requests.RequestException))

    def find_clusters(self):
        find_req = federated_pb2.FindClustersRequest()
        resp = self._retry(self._federated_stub.find_clusters, find_req)
        return resp.value
