from __future__ import unicode_literals

import os

import six
from sepelib.util import fs


class SecretVolumePlugin(object):
    SECRET_MOUNT_PATH_PERMISSIONS = 0o700
    SECRETS_PERMISSIONS = 0o600

    def setup(self, work_dir, client, volume_name, secret):
        """
        :type work_dir: unicode
        :type volume_name: unicode
        :type secret: types_pb2.KeychainSecret | types_pb2.VaultSecret
        :type client: instancectl.clients.vault.client.VaultClient | instancectl.clients.yav.client.YavClient
        """
        content = client.get_secret(secret=secret)

        mount_path = os.path.join(work_dir, volume_name)
        fs.makedirs_ignore(mount_path, mode=self.SECRET_MOUNT_PATH_PERMISSIONS)

        for key, value in six.iteritems(content):
            file_path = os.path.join(mount_path, key)

            # We want specific file permissions for the secret, it might be done in different ways,
            # we use low-level file descriptor operations
            fd = os.open(file_path, os.O_WRONLY | os.O_CREAT, self.SECRETS_PERMISSIONS)
            try:
                os.write(fd, value.encode('utf-8'))
            except UnicodeDecodeError:
                os.write(fd, value)
            finally:
                os.close(fd)
