from yp_proto.yp.client.hq.proto import types_pb2
from infra.yp_service_discovery.api import api_pb2 as sd_api_pb2

instance_type = types_pb2.Instance
endpoint_type = sd_api_pb2.TEndpoint


def validate_instance_type(instance):
    if type(instance) is not instance_type:
        raise TypeError('Filter only applicable to iterable({})'.format(instance_type))


def validate_endpoint_type(endpoint):
    if type(endpoint) is not endpoint_type:
        raise TypeError('Filter only applicable to iterable({})'.format(endpoint_type))


def last_revision(instances):
    """
    :type instances: list[clusterpb.types_pb2.Instance]
    :rtype: list[clusterpb.types_pb2.Instance]
    """
    instances_list = list(instances)
    last_rev_id = None
    for instance in instances_list:
        validate_instance_type(instance)
        if instance.meta.service_id != instances_list[0].meta.service_id:
            raise TypeError('Cannot filter instances of more than one service')
        for revision in instance.status.revision:
            last_rev_id = max(last_rev_id, revision.id)
    if last_rev_id is None:
        return []
    result = []
    for instance in instances_list:
        for revision in instance.status.revision:
            if revision.id == last_rev_id:
                result.append(instance)
                break
    return result


def alive(instances):
    """
    :type instances: list[clusterpb.types_pb2.Instance]
    :rtype: list[clusterpb.types_pb2.Instance]
    """
    result = []
    for instance in instances:
        validate_instance_type(instance)
        if instance.status.ready.status == 'True':
            result.append(instance)
    return result


def ready_endpoints(endpoints):
    """

    :type endpoints: list[sd_sd_api_pb2.TEndpoint]
    :rtype: list[sd_sd_api_pb2.TEndpoint]
    """
    result = []
    for endpoint in endpoints:
        validate_endpoint_type(endpoint)
        if endpoint.ready:
            result.append(endpoint)
    return result


def alive_or_last_revision(instances):
    """
    :type instances: list[clusterpb.types_pb2.Instance]
    :rtype: list[clusterpb.types_pb2.Instance]
    """
    instances_list = list(instances)
    alive_instances = alive(instances_list)
    if len(alive_instances):
        return alive_instances
    else:
        return last_revision(instances_list)


def revision_filter(instances, rev_id):
    """
    :type instances: list[clusterpb.types_pb2.Instance]
    :type rev_id: str | unicode
    :rtype: list[clusterpb.types_pb2.Instance
    """
    def copy_with_revision(obj, r):
        obj_ = types_pb2.Instance()
        obj_.CopyFrom(obj)
        del obj_.spec.revision[:]
        r_ = obj_.spec.revision.add()
        r_.CopyFrom(r)
        return obj_

    result = []
    for instance in instances:
        for revision in instance.spec.revision:
            if revision.id == rev_id:
                instance_ = copy_with_revision(instance, revision)
                result.append(instance_)
                break
    return result
