from __future__ import unicode_literals

import os

import logging

import instancectl.errors
from instancectl import constants
from instancectl import utils
from sepelib.util import fs

log = logging.getLogger()
event_log = logging.getLogger('actions.start')


def lock_file():
    """
    :rtype: file
    """
    state_dir_path = os.path.dirname(constants.LOOP_LOCK_RELATIVE_PATH)
    try:
        fs.makedirs_ignore(state_dir_path)
        lock = open(constants.LOOP_LOCK_RELATIVE_PATH, 'a')
    except Exception:
        log.critical('Failed to open main lock file %s', constants.LOOP_LOCK_RELATIVE_PATH, exc_info=True)
        event_log.critical('Failed to open main lock file %s', constants.LOOP_LOCK_RELATIVE_PATH,
                           exc_info=True)
        raise

    if not utils.lock(lock):
        log.critical('Failed to lock main lock file %s', constants.LOOP_LOCK_RELATIVE_PATH, exc_info=True)
        event_log.critical('Failed to lock main lock file %s', constants.LOOP_LOCK_RELATIVE_PATH,
                           exc_info=True)
        raise instancectl.errors.InstanceCtlCannotAcquireLock('Cannot acquire {}'.format(
            constants.LOOP_LOCK_RELATIVE_PATH))

    return lock
