from __future__ import unicode_literals

from yp_proto.yp.client.hq.proto import types_pb2

from . import errors


class HandlerRunnerArguments(object):

    __slots__ = ['exec_args']

    def __init__(self, exec_args):
        """
        :type exec_args: list[unicode]
        """
        self.exec_args = exec_args


class HandlerRunner(object):

    def __init__(self, http_get_runner, exec_runner):
        """
        :type http_get_runner: instancectl.lib.handler.http_get_runner.HttpGetRunner
        :type exec_runner: instancectl.lib.handler.exec_runner.ExecRunner
        """
        self.http_get_runner = http_get_runner
        self.exec_runner = exec_runner

    def run(self, handler, args):
        """
        :type handler: clusterpb.types_pb2.Handler
        :type args: HandlerRunnerArguments
        """
        if handler.type == types_pb2.Handler.EXEC:
            cmd = list(handler.exec_action.command)
            cmd.extend(args.exec_args)
            self.exec_runner.run(cmd, timeout=None, additional_env={})
        elif handler.type == types_pb2.Handler.HTTP_GET:
            self.http_get_runner.run(handler.http_get)
        else:
            raise errors.HandlerRunnerError('Unsupported handler type: {}'.format(handler.type))
