from __future__ import unicode_literals

import urlparse

import gevent
import requests

from instancectl import constants

from . import errors


class HttpGetRunner(object):

    PROCESS_CHECK_TIMEOUT = 0.1

    def run(self, spec):
        """
        :type spec: clusterpb.types_pb2.HTTPGetAction
        """
        headers = {h.name: h.value for h in spec.http_headers}
        t = (spec.uri_scheme, '{}:{}'.format(spec.host, spec.port), spec.path, '', '', '')
        u = urlparse.urlunparse(t)
        try:
            with gevent.Timeout(constants.DEFAULT_HTTP_GET_RUNNER_TIMEOUT):
                r = requests.get(u, headers=headers)
            r.raise_for_status()
        except gevent.Timeout as e:
            raise errors.HttpGetRunnerTimeoutError('HTTP GET timed out: {}'.format(e))
        except Exception as e:
            raise errors.HttpGetRunnerError('HTTP GET failed: {}'.format(e))
