import socket


RESOLVE_HOSTNAME_ATTEMPTS = 2


def resolve_host(host, ip_version=socket.AF_INET, attempts=RESOLVE_HOSTNAME_ATTEMPTS):
    """
    :type host: unicode
    :type ip_version: int
    :type attempts: int
    :rtype: list[unicode]
    """
    if ip_version != socket.AF_INET and ip_version != socket.AF_INET6:
        raise ValueError('Unknown IP version {}'.format(ip_version))

    error = None
    for i in xrange(attempts):
        try:
            resolved = socket.getaddrinfo(host, None, ip_version)
            addrs = {unicode(ip[4][0]) for ip in resolved}
            return list(addrs)
        except socket.gaierror as error:
            if error.errno in (socket.EAI_NODATA, socket.EAI_NONAME):
                # next attempt would be useless
                break
    raise error


def resolve_ipv6_addr(host):
    """
    :type host: unicode
    :rtype: list[unicode]
    """
    return resolve_host(host, ip_version=socket.AF_INET6)


def resolve_ipv4_addr(host):
    """
    :type host: unicode
    :rtype: list[unicode]
    """
    return resolve_host(host, ip_version=socket.AF_INET)
