# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

import gevent

from instancectl.lib.procutil import ExecuteHelper
from instancectl.lib import procutil
from . import interfaces


class PopenProcess(interfaces.IProcess):

    WAIT_DELAY = 0.5

    def __init__(self, section, command, pass_fds, cwd, stdout='/dev/null', stderr='/dev/null', env=None, limits=None):
        """
        :type command: list[str|unicode]
        :type env: dict
        :param list[int] pass_fds: дескрипторы, которые нужно унаследовать в дочернем процессе,
          чтобы bsconfig мог убить все запущенные процессы с помощью fuser
        :type stdout: file
        :type stderr: file
        :type limits: dict[unicode, instancectl.common.RLimit]
        :type cwd: unicode
        """
        self._process = None
        self._command = command
        self._pass_fds = pass_fds
        self._env = env or {}
        self._stdout = stdout
        self._stderr = stderr
        self._limits = limits or {}
        self._section = section
        self._log = logging.getLogger('subprocess[{}]'.format(section))
        self._cwd = cwd

        self.pid = None

    def start(self):
        execute_helper = ExecuteHelper(self._limits)

        self._process = procutil.ExtendedPopen(
            self._command,
            stdout=self._stdout,
            stderr=self._stderr,
            preexec_fn=execute_helper,
            shell=False,
            close_fds=True,
            pass_fds=self._pass_fds[:],
            env=self._env,
            cwd=self._cwd,
        )

        self.pid = self._process.pid

    def get_exit_status(self):
        return self._process.get_exit_status()

    def wait(self, timeout):
        try:
            with gevent.Timeout(timeout):
                self._process.wait()
        except gevent.Timeout:
            return None
        return self.get_exit_status()

    def terminate(self):
        self._process.terminate()

    def kill(self):
        self._process.kill()
