from __future__ import unicode_literals

from sepelib.util import retry

from instancectl import constants


def are_revision_statuses_equal(s1, s2):
    """
    :type s1: clusterpb.types_pb2.RevisionStatus
    :type s2: clusterpb.types_pb2.RevisionStatus
    :rtype: bool
    """
    return s1.installed.status == s2.installed.status and s1.ready.status == s2.ready.status


def are_container_statuses_equal(s1, s2):
    """
    :type s1: clusterpb.types_pb2.ContainerStatus
    :type s2: clusterpb.types_pb2.ContainerStatus
    :rtype: bool
    """
    return s1.ready.status == s2.ready.status


def update_rev_status(s, criterion_containers):
    """
    :type s: clusterpb.types_pb2.RevisionStatus
    :type criterion_containers: list[unicode]
    :rtype: bool
    """
    old_ready = s.ready.status
    s.ready.status = constants.CONDITION_TRUE
    s.ready.reason = 'RevisionReady'
    s.ready.last_transition_time.seconds = max(c.ready.last_transition_time.seconds for c in s.container)
    for c in s.container:
        if c.name in criterion_containers and c.ready.status != constants.CONDITION_TRUE:
            s.ready.status = constants.CONDITION_FALSE
            s.ready.reason = 'RevisionNotReady'
            break
    return s.ready.status != old_ready


def format_status(s):
    """
    :type s: clusterpb.types_pb2.RevisionStatus | clusterpb.types_pb2.ContainerStatus
    """
    return ('Ready={s.ready.status} ({s.ready.reason}), '
            'Installed={s.installed.status} ({s.installed.reason})'.format(s=s))


def make_sleeper_from_probe(p):
    """
    :type p: clusterpb.types_pb2.Probe
    :rtype: sepelib.util.retry.RetrySleeper
    """
    return retry.RetrySleeper(delay=p.min_period_seconds,
                              backoff=p.period_backoff,
                              max_delay=p.max_period_seconds,
                              max_jitter=0)
