# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import sys
import struct

from gevent import socket
from gevent import pywsgi


# hopefully they don't break ABI
# SO_PEERCRED is defined only in python3.3
SO_PEERCRED = 17


class UnixsocketWSGIHandler(pywsgi.WSGIHandler):

    def __init__(self, sock, address, server, rfile=None):
        # socket.accept returns empty string ('') as source address in case of unix socket
        # and pywsgi.WSGIHandler uses it to set env['REMOTE_ADDR'] variable. Here we try to work around it
        if self._is_get_peer_id_enabled():
            address = self._get_address(sock)
        else:
            address = '', 0
        super(UnixsocketWSGIHandler, self).__init__(sock, address, server, rfile)

    @staticmethod
    def _is_get_peer_id_enabled():
        """
        :rtype: bool
        """
        return sys.platform.startswith('linux')

    @staticmethod
    def _get_address(sock):
        """
        :rtype: tuple
        """
        cmd = 'unknown'
        res = sock.getsockopt(socket.SOL_SOCKET, SO_PEERCRED, struct.calcsize(b'3i'))
        pid, uid, gid = struct.unpack('3i', res)
        if pid != 0:
            try:
                with open('/proc/{}/cmdline'.format(pid)) as fd:
                    cmd = fd.read()
            except Exception:
                pass
        return 'pid:{!r} - uid:{!r} - gid:{!r} - cmd:{!r}'.format(pid, uid, gid, cmd), 0
