from gevent import sleep
from gevent.timeout import Timeout
from gevent.socket import socket, error, timeout, getaddrinfo, SOL_SOCKET, SO_ERROR, AF_UNIX
from errno import EISCONN, EINVAL, EWOULDBLOCK, EINPROGRESS, EALREADY
from os import strerror


def connect(self, address):
    if self.timeout == 0.0:
        return self._sock.connect(address)
    sock = self._sock
    if isinstance(address, tuple):
        r = getaddrinfo(address[0], address[1], sock.family)
        address = r[0][-1]
    if self.timeout is not None:
        timer = Timeout.start_new(self.timeout, timeout('timed out'))
    else:
        timer = None
    try:
        while True:
            err = sock.getsockopt(SOL_SOCKET, SO_ERROR)
            if err:
                raise error(err, strerror(err))
            result = sock.connect_ex(address)
            if result == EWOULDBLOCK:
                # Do not retry EAGAIN immediately
                # Otherwise we get busyloop if other side's accept queue is full
                sleep(0.5)
            if not result or result == EISCONN:
                break
            elif (result in (EWOULDBLOCK, EINPROGRESS, EALREADY)) or (result == EINVAL and is_windows):
                self._wait(self._write_event)
            else:
                raise error(result, strerror(result))
    finally:
        if timer is not None:
            timer.cancel()


def patch():
    socket.connect = connect
