# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from instancectl.jobs import controller
from instancectl.lib import rpc
from infra.nanny.instancectl.proto import instancectl_pb2

control_blueprint = rpc.blueprint.HttpRpcBlueprint('api.control', __name__, '/rpc/control')


@control_blueprint.method('ReopenInstanceLogs',
                          instancectl_pb2.ReopenInstanceLogsRequest,
                          instancectl_pb2.ReopenInstanceLogsResponse)
def reopen_instance_logs(request, auth_subject):
    pool = controller.IJobController.instance()
    pool.reopenlogs()
    return instancectl_pb2.ReopenInstanceLogsResponse()


@control_blueprint.method('StopInstance',
                          instancectl_pb2.StopInstanceRequest,
                          instancectl_pb2.StopInstanceResponse)
def stop_instance(request, auth_subject):
    runner = controller.IJobController.instance()
    success = runner.stop()
    return instancectl_pb2.StopInstanceResponse(success=success)


@control_blueprint.method('NotifyInstanceDynamicResourcesUpdated',
                          instancectl_pb2.NotifyInstanceDynamicResourcesUpdatedRequest,
                          instancectl_pb2.NotifyInstanceDynamicResourcesUpdatedResponse)
def stop_instance(request, auth_subject):
    runner = controller.IJobController.instance()
    c = runner.notify(list(request.updates))
    resp = instancectl_pb2.NotifyInstanceDynamicResourcesUpdatedResponse()
    resp.success.CopyFrom(c)
    return resp
