# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from instancectl.status import interfaces
from instancectl.lib import rpc
from infra.nanny.instancectl.proto import instancectl_pb2


status_blueprint = rpc.blueprint.HttpRpcBlueprint('api.status', __name__, '/rpc/status')


@status_blueprint.method('GetInstanceRevisionStatus',
                         instancectl_pb2.GetInstanceRevisionStatusRequest,
                         instancectl_pb2.GetInstanceRevisionStatusResponse)
def get_instance_revision_status(request, auth_subject):
    checker = interfaces.IInstanceRevisionStatusCacher.instance()
    status = checker.get_status()
    return instancectl_pb2.GetInstanceRevisionStatusResponse(status=status)
