from __future__ import unicode_literals

from yp_proto.yp.client.hq.proto import types_pb2

from infra.nanny.instancectl.proto import instancectl_pb2
from instancectl import constants


class ContainerStatusEvaluator(object):

    def __init__(self, spec, job):
        """
        :type spec: clusterpb.types_pb2.
        :type job: instancectl.jobs.job.Job
        """
        self.spec = spec
        self.job = job

    def make_container_status(self):
        """
        :rtype: clusterpb.types_pb2.ContainerStatus
        """
        job_state = self.job.get_state()
        s = types_pb2.ContainerStatus()
        s.name = self.job.name
        s.restart_count = job_state.restart_count
        s.last_termination_status.CopyFrom(job_state.last_termination_status)
        c = self.make_installed_condition(job_state)
        s.installed.CopyFrom(c)
        c = self.make_ready_condition(job_state)
        s.ready.CopyFrom(c)
        return s

    @staticmethod
    def make_installed_condition(state):
        """
        :type state: infra.nanny.instancectl.proto.instancectl_pb2.ContainerInternalState
        """
        c = types_pb2.Condition()
        c.last_transition_time.CopyFrom(state.last_state_change_time)
        if state.state == instancectl_pb2.ContainerInternalState.NOT_PREPARED:
            c.status = constants.CONDITION_FALSE
            c.reason = 'ContainerNotInstalled'
            return c
        c.status = constants.CONDITION_TRUE
        c.reason = 'ContainerInstalled'
        return c

    def make_ready_condition(self, state):
        """
        :type state: infra.nanny.instancectl.proto.instancectl_pb2.ContainerInternalState
        """
        if not self.job.ready():
            p = self.job.get_prober()
            return p.probe(self.spec)
        c = types_pb2.Condition()
        c.last_transition_time.CopyFrom(state.last_state_change_time)
        c.status = constants.CONDITION_FALSE
        c.reason = 'ContainerWatcherNotStarted'
        return c
