from __future__ import unicode_literals

from yp_proto.yp.client.hq.proto import types_pb2

from instancectl.lib.handler import errors
from instancectl import constants


class ExecProber(object):

    def __init__(self, exec_runner):
        """
        :type exec_runner: instancectl.lib.handler.exec_runner.ExecRunner
        """
        self.exec_runner = exec_runner

    def probe(self, spec):
        """
        :type spec: clusterpb.types_pb2.ExecAction
        :rtype: clusterpb.types_pb2.Condition
        """
        c = types_pb2.Condition()
        c.last_transition_time.GetCurrentTime()
        try:
            self.exec_runner.run(spec.command, timeout=None, additional_env={})
        except errors.ExecRunnerError:
            c.status = constants.CONDITION_FALSE
            c.reason = 'StatusScriptFail'
            return c
        c.status = constants.CONDITION_TRUE
        c.reason = 'StatusScriptOk'
        return c
