from __future__ import unicode_literals

from yp_proto.yp.client.hq.proto import types_pb2

from instancectl.lib import handler
from instancectl import constants


class HttpGetProber(object):

    def __init__(self):
        self.runner = handler.HttpGetRunner()

    def probe(self, spec):
        """
        :type spec: clusterpb.types_pb2.HttpGetAction
        :rtype: clusterpb.types_pb2.Condition
        """
        c = types_pb2.Condition()
        c.last_transition_time.GetCurrentTime()

        try:
            self.runner.run(spec)
        except handler.HandlerRunnerError:
            c.status = constants.CONDITION_FALSE
            c.reason = 'HttpGetFail'
            return c
        c.status = constants.CONDITION_TRUE
        c.reason = 'HttpGetOk'
        return c

