from __future__ import unicode_literals

from yp_proto.yp.client.hq.proto import types_pb2

from instancectl import constants
from . import tcp_socket
from . import http_get
from .. import errors


class Prober(object):

    def __init__(self, exec_prober):
        self.tcp_prober = tcp_socket.TcpSocketProber()
        self.http_prober = http_get.HttpGetProber()
        self.exec_prober = exec_prober

    def probe(self, spec):
        """
        :type spec: clusterpb.types_pb2.Probe
        :rtype: clusterpb.types_pb2.Condition
        """
        c = types_pb2.Condition()
        c.last_transition_time.GetCurrentTime()
        c.status = constants.CONDITION_TRUE
        c.reason = 'ContainerReady'
        for h in spec.handlers:
            if h.type == types_pb2.Handler.EXEC:
                c = self.exec_prober.probe(h.exec_action)
            elif h.type == types_pb2.Handler.HTTP_GET:
                c = self.http_prober.probe(h.http_get)
            elif h.type == types_pb2.Handler.TCP_SOCKET:
                c = self.tcp_prober.probe(h.tcp_socket)
            else:
                raise errors.StatusEvaluationError('Unknown status handler type: {}'.format(h.type))
            if c.status == constants.CONDITION_FALSE:
                return c
        return c
