from __future__ import unicode_literals

import socket

import gevent
from yp_proto.yp.client.hq.proto import types_pb2

from instancectl import constants


class TcpSocketProber(object):
    def __init__(self, create_conn_fun=None):
        # Make create_connection a variable to allow patching in tests
        self.create_conn_fun = create_conn_fun or socket.create_connection

    def probe(self, spec):
        """
        :type spec: clusterpb.types_pb2.TcpSocketAction
        :rtype: clusterpb.types_pb2.Condition
        """
        c = types_pb2.Condition()
        c.last_transition_time.GetCurrentTime()
        try:
            with gevent.Timeout(constants.CHECK_PORT_TIMEOUT):
                sock = self.create_conn_fun(address=(spec.host, int(spec.port)))
        except socket.gaierror as e:
            c.status = constants.CONDITION_FALSE
            c.reason = 'DNSFail'
            c.message = '"{}" resolve failed: {}'.format(spec.host, e.strerror)
        except gevent.Timeout:
            c.status = constants.CONDITION_FALSE
            c.reason = 'Timeout'
            c.message = 'TCP connect({}:{}) timed out after {}s.'.format(
                    spec.host, spec.port, constants.CHECK_PORT_TIMEOUT,
                    )
        except Exception as e:
            c.status = constants.CONDITION_FALSE
            c.reason = 'CheckPortFail'
            c.message = 'TCP connect({}:{}) failed: {}'.format(
                    spec.host, spec.port, e
                    )
        else:
            sock.close()
            c.status = constants.CONDITION_TRUE
            c.reason = 'CheckPortOk'
            c.message = 'Port check OK'
        return c

