from __future__ import unicode_literals

import logging

from sepelib.gevent import greenthread

from instancectl.lib import statusutil
from .. import container_status_evaluator


class LegacyContainerStatusUpdater(greenthread.GreenThread):
    """
    Legacy container status checker:
    * Ignores actual process liveness, report OK even if process is dead
    """

    def __init__(self, job, spec, cacher):
        """
        :type job: instancectl.jobs.job.Job
        :type spec: clusterpb.types_pb2.Probe
        :type cacher: instancectl.status.cacher.InstanceRevisionStatusCacher
        """
        super(LegacyContainerStatusUpdater, self).__init__()
        self.log = logging.getLogger('status-updater_{}'.format(job.name))
        self.job = job
        self.spec = spec
        self.cacher = cacher
        self.evaluator = container_status_evaluator.ContainerStatusEvaluator(spec, job)
        self.sleeper = statusutil.make_sleeper_from_probe(spec)

    def update_status(self):
        self.log.info('Start status computation')
        s = self.evaluator.make_container_status()
        self.log.info('New status: %s', statusutil.format_status(s))
        return self.cacher.set_container_status(s)

    def _run(self):
        updated = self.update_status()
        if updated:
            self.log.info('Status changed, reset check sleeper')
            self.sleeper.reset()

    def run(self):
        while True:
            try:
                self._run()
            except Exception:
                self.log.exception('Status updating fail')
            self.sleeper.increment()
