from __future__ import unicode_literals


class InstanceRevisionStatusUpdater(object):
    """
    Starts multiple threads which periodically probes readiness of containers.
    """

    def __init__(self, updaters):
        self.updaters = updaters

    def start(self):
        for u in self.updaters:
            u.start()

    def stop(self):
        for u in self.updaters:
            u.stop()

    def update_instance_status(self):
        for u in self.updaters:
            u.update_status()
