from __future__ import unicode_literals

import logging

from yp_proto.yp.client.hq.proto import types_pb2
from sepelib.gevent import greenthread

from instancectl import constants
from .. import prober


class LegacyTcpActionStatusUpdater(greenthread.GreenThread):
    """
    Makes TCP check periodically
    """

    def __init__(self, spec, cacher, sleeper, job_ctrl):
        """
        :type spec: clusterpb.types_pb2.TcpSocketAction
        :type job_ctrl: instancectl.jobs.controller.JobController
        :type cacher: instancectl.status.cacher.InstanceRevisionStatusCacher
        :type sleeper: sepelib.util.retry.RetrySleeper
        """
        super(LegacyTcpActionStatusUpdater, self).__init__()
        self.log = logging.getLogger('tcp-socket-checker')
        self.spec = spec
        self.cacher = cacher
        self.sleeper = sleeper
        self.tcp_prober = prober.TcpSocketProber()
        self.job_ctrl = job_ctrl

    def _make_status(self):
        """
        :rtype: clusterpb.types_pb2.Condition
        """
        if not self.job_ctrl.all_jobs_running():
            s = types_pb2.Condition()
            s.status = constants.CONDITION_FALSE
            s.reason = 'RevisionNotReady'
            s.last_transition_time.GetCurrentTime()
            return s
        self.log.info('Making TCP socket check to calculate instance status')
        s = self.tcp_prober.probe(self.spec)
        self.log.info('TCP check result: %s (%s)', s.status, s.reason)
        return s

    def update_status(self):
        s = self._make_status()
        return self.cacher.set_ready_condition(s)

    def _run(self):
        updated = self.update_status()
        if updated:
            self.log.info('Status changed, reset check sleeper')
            self.sleeper.reset()

    def run(self):
        while True:
            try:
                self._run()
            except Exception:
                self.log.exception('Instance status updating fail')
            self.sleeper.increment()
