PY2_LIBRARY()

OWNER(
    g:nanny
)

PEERDIR(
    contrib/python/requests
    contrib/python/enum34
    contrib/python/fallocate
    contrib/python/Flask
    contrib/python/Jinja2
    contrib/python/protobuf
    contrib/python/Inject

    sandbox/sdk2/helpers/coredump_filter/minidump2core/src

    library/python/deprecated/ticket_parser2

    infra/nanny/vendor/iss3lib
    infra/nanny/vendor/porto_python
    infra/nanny/sepelib/core
    infra/nanny/sepelib/util
    infra/nanny/sepelib/gevent
    infra/nanny/sepelib/subprocess
    infra/nanny/nanny_rpc_client
    infra/nanny/clusterpb
    infra/nanny/its_client
    infra/nanny/instancectl/src/corewriter
    infra/nanny/instancectl/proto
    infra/nanny2/stubs/python

    infra/yp_service_discovery/python/resolver
)

PYTHON(write_token.py STDOUT nanny_vault_oauth_token OUT_NOAUTO nanny_vault_oauth_token)
PYTHON(write_tvm_secret.py STDOUT nanny_tvm_secret OUT_NOAUTO nanny_tvm_secret)

RESOURCE(
    nanny_vault_oauth_token /secrets/nanny_vault_oauth_token
    nanny_tvm_secret /secrets/nanny_tvm_secret
)

PY_SRCS(
    TOP_LEVEL
    instancectl/__init__.py
    instancectl/actions/__init__.py
    instancectl/actions/install.py
    instancectl/actions/interfaces.py
    instancectl/actions/start.py
    instancectl/actions/uninstall.py
    instancectl/cmd/__init__.py
    instancectl/cmd/call_reopenlog.py
    instancectl/cmd/get_status.py
    instancectl/cmd/print_status.py
    instancectl/cmd/install.py
    instancectl/cmd/notify.py
    instancectl/cmd/send_minidump.py
    instancectl/cmd/start.py
    instancectl/cmd/stop_instance.py
    instancectl/cmd/core_process.py
    instancectl/cmd/uninstall.py
    instancectl/cmd/log.py
    instancectl/clients/__init__.py
    instancectl/clients/unixsocket_rpc/__init__.py
    instancectl/clients/unixsocket_rpc/adapters.py
    instancectl/clients/unixsocket_rpc/client.py
    instancectl/clients/unixsocket_rpc/exceptions.py
    instancectl/clients/vault/__init__.py
    instancectl/clients/vault/client.py
    instancectl/clients/vault/errors.py
    instancectl/clients/vault/helpers.py
    instancectl/clients/yav/__init__.py
    instancectl/clients/yav/client.py
    instancectl/clients/yav/errors.py
    instancectl/cms.py
    instancectl/errors.py
    instancectl/config/__init__.py
    instancectl/config/config.py
    instancectl/config/errors.py
    instancectl/config/defaults.py
    instancectl/config/helpers.py
    instancectl/common.py
    instancectl/constants.py
    instancectl/sd/__init__.py
    instancectl/sd/client.py
    instancectl/sd/helpers.py
    instancectl/hq/__init__.py
    instancectl/hq/federated_client.py
    instancectl/hq/helpers.py
    instancectl/hq/instance_client.py
    instancectl/hq/reporter.py
    instancectl/hq/volumes/__init__.py
    instancectl/hq/volumes/errors.py
    instancectl/hq/volumes/its.py
    instancectl/hq/volumes/secret.py
    instancectl/hq/volumes/template.py
    instancectl/hq/volumes/template_filters.py
    instancectl/status/__init__.py
    instancectl/status/cacher.py
    instancectl/status/container_status_evaluator.py
    instancectl/status/errors.py
    instancectl/status/external.py
    instancectl/status/interfaces.py
    instancectl/status/prober/__init__.py
    instancectl/status/prober/exec_action.py
    instancectl/status/prober/http_get.py
    instancectl/status/prober/prober.py
    instancectl/status/prober/tcp_socket.py
    instancectl/status/updater/__init__.py
    instancectl/status/updater/container.py
    instancectl/status/updater/container_legacy.py
    instancectl/status/updater/instance.py
    instancectl/status/updater/tcp_check_legacy.py
    instancectl/jobs/errors.py
    instancectl/jobs/helpers.py
    instancectl/jobs/job.py
    instancectl/jobs/jobpool.py
    instancectl/jobs/controller.py
    instancectl/jobs/stdout_rotater.py
    instancectl/lib/__init__.py
    instancectl/lib/actionsutil.py
    instancectl/lib/confutil.py
    instancectl/lib/specutil.py
    instancectl/lib/envutil.py
    instancectl/lib/fileutil.py
    instancectl/lib/portoutil.py
    instancectl/lib/handler/__init__.py
    instancectl/lib/handler/errors.py
    instancectl/lib/handler/exec_runner.py
    instancectl/lib/handler/handler_runner.py
    instancectl/lib/handler/http_get_runner.py
    instancectl/lib/jsonschemautil.py
    instancectl/lib/netutil.py
    instancectl/lib/pbutil.py
    instancectl/lib/process/__init__.py
    instancectl/lib/process/popen.py
    instancectl/lib/process/porto_container.py
    instancectl/lib/process/interfaces.py
    instancectl/lib/procutil.py
    instancectl/lib/rpc/__init__.py
    instancectl/lib/rpc/blueprint.py
    instancectl/lib/rpc/exceptions.py
    instancectl/lib/rpc/parse_request.py
    instancectl/lib/rpc/status_pb2.py
    instancectl/lib/schemas/__init__.py
    instancectl/lib/schemas/db_schema_pb2.py
    instancectl/lib/schemas/field_schema_pb2.py
    instancectl/lib/schemas/message_schema_pb2.py
    instancectl/lib/schemas/rpc_schema_pb2.py
    instancectl/lib/statusutil.py
    instancectl/lib/unixsocket.py
    instancectl/main.py
    instancectl/monkey/__init__.py
    instancectl/monkey/gevent_connect.py
    instancectl/coredumps/__init__.py
    instancectl/coredumps/sender.py
    instancectl/coredumps/processors.py
    instancectl/rpc/__init__.py
    instancectl/rpc/status.py
    instancectl/rpc/control.py
    instancectl/utils.py
    instancectl/version.py
    instancectl/lib/minidumputil.py
    instancectl/lib/coreaggrutil.py
)

END()
