#!/usr/bin/env python
# coding: utf-8
import sys

import click

sys.path.append('./src/')

from releaselib.cli import log, commands


logger = log.setup_logging()


@click.group()
def main():
    """Release toolkit."""
    pass


release = commands.get_release_command(tag_url_template='https://git.qe-infra.yandex-team.ru/projects/NANNY/'
                                                        'repos/its_client/commits?until=refs%2Ftags%2F{}',
                                       use_prefixed_tags=True, annotate_with_stash=True)


if __name__ == '__main__':
    main.add_command(release)
    main.add_command(commands.upload_to_pypi)
    main()
