from __future__ import unicode_literals
import argparse
import sys
import os
import pprint

from instancectl.hq.volumes import template
from instancectl.hq.volumes import errors
from instancectl import utils
import lib.util as util
import lib.constant as constant


def parse_args(argv):
    argv = [arg.decode("utf-8") for arg in argv]

    parser = argparse.ArgumentParser()
    parser.add_argument('-v', '--version', action='version', version=constant.VERSION)
    parser.add_argument('-n', '--service', type=str, required=True, help='Service name')
    parser.add_argument('-p', '--port', type=int, required=False, default=None, help='Service port')
    parser.add_argument('-i', '--instance', type=str, required=True, help='Service instance')
    parser.add_argument('--show-context', action='store_true', default=False, help='Show context')
    parser.add_argument('-s', '--template-file', type=argparse.FileType('r'), required=True, help='Template file')
    parser.add_argument('-d', '--result-file', type=argparse.FileType('w'), required=True, help='Result template file')

    return parser.parse_args(argv)


def main():
    args = parse_args(sys.argv[1:])
    resp = util.get_hq_object(instance=args.instance, port=args.port, service=args.service)

    context = util.make_template_plugin_context(constant.FEDERATED_URL, resp)

    if args.show_context:
        print(" --- context --- ")
        pprint.pprint(context)
        print(" --- ")
        print("")

    template_volume_plugin = template.TemplateVolumePlugin(context, instance_dir='.')
    try:
        content = template_volume_plugin._render_content(str(args.template_file.name), context)
    except Exception as e:
        raise utils.make_exc(errors.TemplateProcessingError,
                             'Cannot process template {}: {}'.format(str(args.template_file.name), e))
    try:
        template_volume_plugin._write_rendered_content(os.path.dirname(args.result_file.name),
                                                       os.path.basename(args.result_file.name),
                                                       content)
    except Exception as e:
        raise utils.make_exc(errors.TemplateProcessingError,
                             'Cannot save volume  {}. {}'.format(args.result_file.name, e))

    print("Success. Template {} save to {} .".format(args.template_file.name, args.result_file.name))
