class IHttpRpcClient(object):
    """
    Interface which every HTTP RPC client must complain.
    """
    def call_remote_method(self, method_name, request_protobuf, response_protobuf, **kwargs):
        """
        Invokes remote method on server by issuing properly crafted HTTP POST request.
        :param method_name: remote method name (e.g. 'SayHello')
        :param request_protobuf: request object - protobuf message
        :param response_protobuf: response object, which will be filled with server response
        :param kwargs: additional information depending on actual implementation (e.g. override parameters)
        """
        raise NotImplementedError


class IRetrySleeper(object):
    """
    Interface which retry sleeper for retrying RPC clients must complain.
    """

    def increment(self, exception=True):
        """
        Increment the failed count, and sleep appropriately before
        continuing. Raises exception if max attempts reached and :param exception: is True.

        :return: False if max attempts reached, True otherwise
        :rtype: bool
        :raises: nanny_rpc_client.exceptions.RpcClientRetryFailedError
        """
        raise NotImplementedError

    def copy(self):
        """
        Returns a clone of this retry sleeper

        :rtype: IRetrySleeper
        """
        raise NotImplementedError
