

class ServiceRepoRequestError(Exception):
    pass


class ServiceRepoResponseError(Exception):
    def __init__(self, *args, **kwargs):
        response = kwargs.pop('response')
        self.response = response.json()
        super(ServiceRepoResponseError, self).__init__(*args, **kwargs)

    def __str__(self):
        return '{}: {}'.format(self.response['error'], self.response['msg'])


class ModificationConflictError(ServiceRepoResponseError):
    pass


class NotFoundError(ServiceRepoResponseError):
    pass
