from __future__ import unicode_literals
import os
import shutil
import contextlib
import json


def yield_source_files(root):
    for d, _, names in os.walk(root):
        for n in names:
            p = os.path.join(d, n)
            if not os.path.islink(p) and os.path.splitext(p)[1] != '.pyc':
                yield p


@contextlib.contextmanager
def force_create_tmp_dir(path):
    if os.path.exists(path):
        shutil.rmtree(path)
    os.mkdir(path)
    try:
        yield path
    finally:
        shutil.rmtree(path)


def get_max_mtime(files):
    if not files:
        return
    return max(os.stat(f).st_mtime for f in files)


def parse_checksum_from_shard_conf(shard_conf):
    prefix = '%attr(md5='
    with open(shard_conf, 'rb') as f:
        for l in f:
            if l.startswith(prefix):
                n = len(prefix)
                return l[n:n + 32]


def parse_checksum_from_dump_json(dump_json, resource_name):
    with open(dump_json, 'rb') as f:
        d = json.load(f)
        v = d.get('resources', {}).get(resource_name, {}).get('verification', {}).get('checksum')
        if v and v.startswith('MD5:'):
            return v[4:]
