#!/usr/bin/env python
from __future__ import unicode_literals
import logging

import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry

TIMEOUT = 5.0
RETRY_LIMIT = 5


def push_juggler(url, host, service, status, instance, desc):
    event = {
        "host": host,
        "service": service,
        "status": status,
        "description": desc
    }
    if instance is not None:
        event["instance"] = instance
    events = {"events": [event]}
    try:
        with requests.Session() as s:
            retries = Retry(
                total=RETRY_LIMIT,
                read=RETRY_LIMIT,
                connect=RETRY_LIMIT,
                backoff_factor=0.5,
                status_forcelist=[500, 502, 503, 504],
                method_whitelist=frozenset(['POST'])
            )
            s.mount("https://", HTTPAdapter(max_retries=retries))
            s.mount("http://", HTTPAdapter(max_retries=retries))
            return s.post(url, json=events, timeout=TIMEOUT)
    except Exception:
        logging.exception("juggler request failed:")
