from setuputils import setup, sdist, load_readme_contents, VERSION, DESCRIPTION, find_lib_packages


setup(
    name='sepelib.flask',
    version=VERSION,
    description=DESCRIPTION,
    long_description=load_readme_contents(),
    packages=find_lib_packages('flask'),
    package_dir={'sepelib': 'src/sepelib'},
    namespace_packages=['sepelib'],
    install_requires=[
        'sepelib.util=={0}'.format(VERSION),
        'sepelib.yandex=={0}'.format(VERSION),
        'sepelib.gevent=={0}'.format(VERSION),
        'sepelib.metrics=={0}'.format(VERSION),
        'sepelib.mongo=={0}'.format(VERSION),
        'cachetools==0.8.1',
        'Flask==0.10.1',
        'Flask-Principal==0.4.0',
        'PyYAML==3.11',
        'msgpack-python==0.2.4',
        'enum34==0.9.19',
    ],
    zip_safe=False,
    cmdclass={'sdist': sdist},
)
