from setuputils import setup, sdist, load_readme_contents, VERSION, DESCRIPTION, find_lib_packages


setup(
    name='sepelib.yandex',
    version=VERSION,
    description=DESCRIPTION,
    long_description=load_readme_contents(),
    packages=find_lib_packages('yandex'),
    package_dir={'sepelib': 'src/sepelib'},
    namespace_packages=['sepelib'],
    install_requires=[
        'sepelib.http=={0}'.format(VERSION),
        'sepelib.util=={0}'.format(VERSION),
        'sepelib.gevent=={0}'.format(VERSION),
        'sepelib.rpc=={0}'.format(VERSION),
        'sepelib.metrics=={0}'.format(VERSION),
        'sepelib.core=={0}'.format(VERSION),
        'requests==2.4.3',
        'bcode==0.5',
        'thrift==0.9.1',
        'iss-thrift3==3.5.2941',
        'shard_tracker==3.4.2850',
        'werkzeug==0.10.4',
        'inject==3.1.1',
        'enum34==0.9.19',
    ],
    zip_safe=False,
    cmdclass={'sdist': sdist},
)
