# coding: utf-8
"""
Common data and utilities for all the setup-*.py files.
"""
import os.path

from setuptools import setup, find_packages
from setuptools.command.sdist import sdist as _sdist

version = '0.5.218'  # to be discovered by releaselib
VERSION = version

DESCRIPTION = 'SEPE utilities library'


def load_readme_contents(filename='README.md'):
    path = os.path.join(os.path.abspath(os.path.dirname(__file__)), filename)
    with open(path) as f:
        return f.read()


def find_lib_packages(lib):
    """
    Find sepelib sub library packages to be used in setuptools.setup.
    If we use vanilla ``find_packages``
        * we either get all packages if we specify 'src/'
        * or we get only subpackages if we specify e.g. 'src/sepelib/util'
    And that is the reason we have this helper function.
    """
    packages = ['sepelib.{}'.format(lib)]
    for package in find_packages(os.path.join('src', 'sepelib', lib)):
        packages.append('sepelib.{}.{}'.format(lib, package))
    return packages


class sdist(_sdist):
    """sdist command to be used in setup-*.py.

    It renames ./setup-smth.py to ./setup.py when placing it in the archive.
    This is necessary because pip is looking for setup.py when installing a package.
    """
    def make_distribution(self):
        # self.distribution.script_name` contains the name of setup.py
        # we're running in
        self.filelist.exclude_pattern(self.distribution.script_name)
        _sdist.make_distribution(self)

    def make_release_tree(self, base_dir, files):
        _sdist.make_release_tree(self, base_dir, files)
        link = 'hard' if hasattr(os, 'link') else None
        dest = os.path.join(base_dir, 'setup.py')
        self.copy_file(self.distribution.script_name, dest, link=link)
