"""Generic constants."""

from __future__ import unicode_literals


MINUTE_SECONDS = 60
"""Number of seconds in minute."""

HOUR_SECONDS = 60 * MINUTE_SECONDS
"""Number of seconds in hour."""

DAY_SECONDS = 24 * HOUR_SECONDS
"""Number of seconds in day."""

WEEK_SECONDS = 7 * DAY_SECONDS
"""Number of seconds in week."""


KILOBYTE = 1024
"""Number of bytes in kilobyte."""

MEGABYTE = 1024 * KILOBYTE
"""Number of bytes in megabyte."""

GIGABYTE = 1024 * MEGABYTE
"""Number of bytes in gigabyte."""


NETWORK_BUFSIZE = 64 * KILOBYTE
"""Buffer size for transferring data over network."""

NETWORK_TIMEOUT = 30
"""Default timeout for all network operations."""
