"""Generic exception classes."""

from __future__ import unicode_literals


class Error(Exception):
    """Base exception class with message formatting."""

    def __init__(self, *args):
        # Don't introduce any named parameters to be able to pass **kwargs to format() in the future
        message, args = args[0], args[1:]
        super(Error, self).__init__(message.format(*args) if args else message)


class LogicalError(Exception):
    """Raised from code that never should be reached."""

    def __init__(self):
        super(Exception, self).__init__("Logical error.")
