"""
Some utilities to work with query part of URL.
"""


class RestListRequest(object):
    def __init__(self, skip, limit):
        self.skip = skip
        self.limit = limit

    @property
    def as_slice(self):
        if self.skip is None:
            left = None
        else:
            left = self.skip
        if self.limit is None:  # no limit provided
            right = None
        elif left is not None:
            right = self.skip + self.limit
        else:
            right = self.limit
        return slice(left, right)


def parse_list_req(args):
    """
    Parse skip and limit arguments from ReST style list of objects request.
    :param args: dict
    :rtype: RestListRequest
    """
    skip = args.get('skip')
    if skip:
        skip = int(skip)
    limit = args.get('limit')
    if limit:
        limit = int(limit)
    return RestListRequest(skip, limit)
