"""Provides various handy decorators."""

from __future__ import unicode_literals

from functools import wraps

from flask import render_template


def templated(template_name):
    """Renders the returned value using the specified template."""

    def decorator(func):
        @wraps(func)
        def decorated(*args, **kwargs):
            ctx = func(*args, **kwargs) or {}
            return render_template(template_name, **ctx)

        return decorated

    return decorator
