# coding: utf-8
"""Flask and MongoEngine integration."""
from flask import abort


def get_obj_or_404(klass, **kwargs):
    """
    :param klass: :class:`mongoengine.Document`
    """
    try:
        return klass.objects.get(**kwargs)
    except klass.DoesNotExist:
        abort(404)
