# coding: utf-8
"""
Some helpers. Currently used to help rendering values in Jinja templates.
"""
import time


__all__ = ['date_to_str', 'format_time', 'format_time_ms', 'format_percent']


UI_DATE_FORMAT = "%d.%m.%Y %H:%M:%S"


def date_to_str(time_t=None):
    """
    Return the current date and time formatted for a message header.
    Copy-paste from BaseHTTPServer.py.
    """
    weekdayname = ('Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun')
    monthname = (None,
                 'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
                 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec')
    if time_t is None:
        time_t = time.time()
    year, month, day, hh, mm, ss, wd, _, _ = time.gmtime(time_t)
    s = "{}, {:02d} {:3} {:4d} {:02d}:{:02d}:{:02d} GMT".format(
        weekdayname[wd],
        day, monthname[month], year,
        hh, mm, ss)
    return s


def format_time(time_t):
    return time.strftime(UI_DATE_FORMAT, time.localtime(time_t))


def format_time_ms(time_t):
    return time.strftime(UI_DATE_FORMAT, time.localtime(time_t / 1000))


def format_datetime(dt):
    return dt.strftime(UI_DATE_FORMAT)


def format_percent(values):
    """
    Format tuple (54, 100) to percent value 54.
    """
    try:
        return int((float(values[0]) / values[1]) * 100)
    except ZeroDivisionError:
        return 0
