# coding=utf-8

import gevent


def gevent_idle_iter(iterable_object, idle_period=100, idle_on_start=False, idle_method=None):
    """
    Make gevent.idle pauses during iteration - call idle_method.
    Do not let gevent block your program!

    :param iterable_object: iterable object
    :type iterable_object: collections.abc.Iterable[T]
    :param idle_period: idle frequency
    :param idle_on_start: make idle before first iteration
    :type idle_on_start: bool
    :param idle_method: idle method object
    :rtype: collections.abc.Iterable[T]
    """
    if idle_method is None:
        idle_method = gevent.idle
    for iterable_item_id, iterable_item in enumerate(iterable_object, 0 if idle_on_start else 1):
        if not iterable_item_id % idle_period:
            idle_method()
        yield iterable_item
