# -*- coding: utf-8 -*-
"""
"""
import cgi

import requests
from requests import RequestException
import object_validator

from sepelib.core import constants


def request(method, url, ok_statuses=None, error_from_contents=False, timeout=constants.NETWORK_TIMEOUT, session=None,
            **kwargs):
    if session:
        response = session.request(method, url, timeout=timeout, **kwargs)
    else:
        response = requests.request(method, url, timeout=timeout, **kwargs)

    if ok_statuses and response.status_code not in ok_statuses:
        if error_from_contents:
            error = response.text.replace("\n", " ").strip()
            if len(error) > 1000:
                error = error[:1000] + "..."
        else:
            error = ""

        raise RequestException("Server returned an error: {} {}.{}".format(
            response.status_code, response.reason, " " + error if error else ""), response=response)

    return response


def json_request(method, url, scheme=None, ok_statuses=None, timeout=constants.NETWORK_TIMEOUT,
                 exception=RequestException, session=None, **kwargs):
    try:
        response = request(method, url, ok_statuses=ok_statuses, timeout=timeout, session=session, **kwargs)
        return get_json_response(response, scheme=scheme, ok_statuses=ok_statuses)
    except RequestException as e:
        new_error = exception('JSON request error: {}'.format(e))

        if hasattr(new_error, 'response'):
            new_error.response = e.response
        raise new_error


def get_json_response(response, scheme=None, ok_statuses=None):
    if ok_statuses and response.status_code not in ok_statuses:
        raise RequestException("Server returned an error: {} {}.".format(response.status_code, response.reason),
                               response=response)

    try:
        content_type, type_options = cgi.parse_header(response.headers.get("Content-Type", ""))
        if content_type != "application/json":
            raise ValueError

        result = response.json(encoding=type_options.get("charset", "utf-8"))
    except Exception as err:
        raise RequestException("The server returned an invalid JSON response.")

    if scheme is not None:
        try:
            result = object_validator.validate("result", result, scheme)
        except object_validator.ValidationError as e:
            raise RequestException("The server returned an invalid JSON response: {}".format(e))

    return result
