from threading import Lock
import uuid


class Counter(object):
    """
    An incrementing and decrementing metric
    """
    def __init__(self):
        super(Counter, self).__init__()
        self.uuid = str(uuid.uuid4())
        self.lock = Lock()
        self.counter = 0

    def inc(self, val=1):
        with self.lock:
            self.counter += val

    def dec(self, val=1):
        self.inc(-val)

    def get_count(self):
        return self.counter

    def clear(self):
        with self.lock:
            self.uuid = str(uuid.uuid4())
            self.counter = 0

    def get_yasm_format_metrics(self):
        return {'count_summ': self.get_count(),
                'count_ammm': self.get_count()}
