from mongoengine.fields import BaseField


class EnumField(BaseField):
    """Enumerator field.

    :type enum: :class:`enum.Enum`
    """
    def __init__(self, enum, *args, **kwargs):
        self.enum = enum
        kwargs['choices'] = [choice for choice in enum]
        super(EnumField, self).__init__(*args, **kwargs)

    def to_python(self, value):
        """Convert a MongoDB-compatible type to a Python type."""
        if value in self.enum:
            return value
        return self.enum[value]

    def to_mongo(self, enum):
        """Convert a Python type to a MongoDB-compatible type."""
        return enum.name
