import six


def _safe_str(s):
    if not isinstance(s, six.string_types):
        return _safe_str(six.text_type(s))
    if isinstance(s, six.text_type):
        return s
    try:
        return s.decode('utf-8')
    except UnicodeDecodeError:
        return s.decode('latin1')


def format_exc(msg, e):
    """
    Pretty format exception, it's like perror.
    :param msg: message to prepend
    :param e: exception to format
    """
    args = msg, e.__class__.__name__, " ".join(_safe_str(i) for i in e.args)
    return u"{0}: type='{1}' args='{2}'".format(*args)
