# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import json
import logging


MAX_ENTRY_LENGTH = 1000


TRANSLATE_MAP = {
    ord('\\'): r'\\',
    ord('\t'): r'\t',
    ord('\n'): r'\n',
    ord('\r'): r'\r',
    ord('\0'): r'\0'
}


class TabSeparatedKeyValueFormatter(logging.Formatter):
    """
    Formatter for writing logs in TSKV format - tab-separated key-value pairs.
    https://wiki.yandex-team.ru/statbox/logrequirements/

    Partially copy-pasted from walle.util.
    """

    def __init__(self, max_value_length=None, **kwargs):
        """
        :type max_value_length: int
        """
        self._max_value_length = max_value_length
        super(TabSeparatedKeyValueFormatter, self).__init__(**kwargs)

    def dict_to_tskv(self, mapping):
        """
        :type mapping: dict
        :rtype: unicode
        """
        pairs = ("{}={}".format(k, self.process_value(v)) for k, v in sorted(mapping.iteritems()))
        return "\t".join(pairs)

    def process_value(self, value):
        """
        :rtype: str | unicode
        """
        if isinstance(value, (dict, list, tuple)):
            return json.dumps(value)

        if isinstance(value, str):
            value = value.decode('utf8')
        elif not isinstance(value, unicode):
            value = unicode(value)

        if self._max_value_length is not None:
            value = value[:self._max_value_length]

        return self.escape_unicode(value)

    @staticmethod
    def escape_unicode(value, translate_map=TRANSLATE_MAP):
        """
        :type value: unicode
        :type translate_map: dict
        :rtype: unicode
        """
        return value.translate(translate_map)

    def format(self, record):
        """
        :type record: logging.LogRecord
        """
        msg = record.msg
        if isinstance(msg, dict):
            record.msg = self.dict_to_tskv(msg)
        return super(TabSeparatedKeyValueFormatter, self).format(record)
