"""Miscellaneous utilities."""

from __future__ import unicode_literals

from sepelib.core.exceptions import Error


def doesnt_override(klass):
    """A decorator which ensures that a class doesn't override anything from it's base classes."""

    def decorator(method):
        if hasattr(klass, method.__name__):
            raise Error("{} overrides {}.{}.", method.__name__, klass.__name__, method.__name__)
        return method

    return decorator
