"""
Simple timer implementation. Has basic defence against misuse.
"""
import time


class SimpleTimer(object):
    def __init__(self, start=False):
        self._is_running = False
        self._start = 0
        self._stop = 0
        if start:
            self.start()

    def format_elapsed(self):
        return "{0:.3f} sec.".format(self.elapsed)

    @property
    def started_at(self):
        return self._start

    @property
    def stopped_at(self):
        return self._stop

    @property
    def elapsed(self):
        return self._stop - self._start

    def start(self):
        if self._is_running:
            raise RuntimeError('timer is already running')
        self._start = time.time()
        self._is_running = True

    def stop(self):
        if not self._is_running:
            raise RuntimeError('timer is not running')
        self._stop = time.time()
        self._is_running = False

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.stop()
